<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\ProviderSanction\Domain\ProviderSanctionRepository;
use App\Modules\ProviderSanction\Infraestructure\MysqlProviderSanctionRepository;

$app->bind(ProviderSanctionRepository::class, fn($app) => $app->make(MysqlProviderSanctionRepository::class));

$router->post(
    '/providerSanction',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderSanction\\ProviderSanctionInsertController@__invoke'
    ]
);

$router->put(
    '/providerSanction',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderSanction\\ProviderSanctionUpdateController@__invoke'
    ]
);

$router->delete(
    '/providerSanction/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderSanction\\ProviderSanctionDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/providerSanction/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderSanction\\ProviderSanctionIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/provider/{IdProvider}/providerSanction/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ProviderSanction\\ProviderSanctionListController@__invoke'
    ]
)->where('IdProvider', '[0-9]*');
