<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\PaxInformation\Domain\PaxInformationRepository;
use App\Modules\PaxInformation\Infraestructure\MysqlPaxInformationRepository;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerRepository;
use App\Modules\PaxInformationPassenger\Infraestructure\MysqlPaxInformationPassengerRepository;

$app->bind(
    PaxInformationRepository::class,
    fn($app) => $app->make(MysqlPaxInformationRepository::class)
);
$app->bind(
    PaxInformationPassengerRepository::class,
    fn($app) => $app->make(MysqlPaxInformationPassengerRepository::class)
);

$router->post(
    '/paxInformation',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@insert'
    ]
);

$router->put(
    '/paxInformation',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@update'
    ]
);

$router->put(
    '/paxInformation/utilize',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@update'
    ]
);

$router->delete(
    '/paxInformation/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@delete'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/paxInformation/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@index'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/booking/{Id_Booking}/paxInformation/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'PaxInformation@list'
    ]
)->where('Id_Booking', '[0-9]*');
