<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerRepository;
use App\Modules\LeadBookingTourPassenger\Infraestructure\MysqlLeadBookingTourPassengerRepository;

$router->post(
    '/leadBookingTourPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTourPassenger\\LeadBookingTourPassengerInsertController@__invoke'
    ]
);

$router->put(
    '/leadBookingTourPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTourPassenger\\LeadBookingTourPassengerUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBookingTourPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTourPassenger\\LeadBookingTourPassengerDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBookingTourPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTourPassenger\\LeadBookingTourPassengerIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBookingTour/{Id_LeadBookingTour}/leadBookingTourPassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingTourPassenger\\LeadBookingTourPassengerListController@__invoke'
    ]
)->where('Id_LeadBookingTour', '[0-9]*');

$app->bind(
    LeadBookingTourPassengerRepository::class,
    fn($app) => $app->make(MysqlLeadBookingTourPassengerRepository::class)
);
