<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\GroupPassenger\Domain\GroupPassengerReportRepository;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\GroupPassenger\Infraestructure\MysqlGroupPassengerReportRepository;
use App\Modules\GroupPassenger\Infraestructure\MysqlGroupPassengerRepository;

$app->bind(GroupPassengerReportRepository::class, fn ($app) => $app->make(MysqlGroupPassengerReportRepository::class));
$app->bind(GroupPassengerRepository::class, fn ($app) => $app->make(MysqlGroupPassengerRepository::class));

// $router->get(
//     '/groupPassenger/reviews/excel',
//     [
//         'uses' => 'GroupPassenger\\GroupPassengerReviewExportToExcelCategorizedController@__invoke'
//     ]
// );

$router->get(
    '/groupPassenger/reviews/excel',
    [
        'uses' => 'GroupPassenger\\GroupPassengerReviewExportToExcelController@__invoke'
    ]
);

$router->post(
    '/groupPassenger/all',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Insert_All'
    ]
);

$router->post(
    '/groupPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Insert'
    ]
);

$router->put(
    '/groupPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Update'
    ]
);

$router->delete(
    '/groupPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Delete'
    ]
);

$router->get(
    '/groupPassenger/gallery/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupPassenger\\GroupPassengerListGalleryController@__invoke'
    ]
);

$router->get(
    '/groupPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@Index'
    ]
);

$router->get(
    '/group/{Id_Group}/groupPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group_Passenger@List'
    ]
);

$router->get(
    '/group/{Id_Group}/groupPassengerWithReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupPassenger\\GroupPassengerListWithReviewController@__invoke'
    ]
)->where('Id_Group', '[0-9]*');


$router->put(
    '/groupPassenger/{Id_GroupPassenger}/mediaStatus',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupPassenger\\GroupPassengerUploadMediaController@__invoke'
    ]
)->where('Id_GroupPassenger', '[0-9]*');

$router->put(
    '/groupPassenger/{Id_GroupPassenger}/mediaScore',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupPassenger\\GroupPassengerUpdateScoreController@__invoke'
    ]
)->where('Id_GroupPassenger', '[0-9]*');

$router->get(
    '/groupPassenger/{Id_GroupPassenger}/downloadMedia',
    [
        'middleware' => 'Auth_Owner_Url',
        'uses' => 'GroupPassenger\\GroupPassengerDownloadMediaController@__invoke'
    ]
)->where('Id_GroupPassenger', '[0-9]*');
