<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactReceipt\Domain\DtoFactReceiptRepository;
use App\Modules\FactReceipt\Domain\FactReceiptRepository;
use App\Modules\FactReceipt\Infraestructure\MysqlFactReceiptRepository;
use App\Modules\FactReceipt\Infraestructure\YachayFactReceiptRepository;

$app->bind(FactReceiptRepository::class, fn ($app) => $app->make(MysqlFactReceiptRepository::class));
$app->bind(DtoFactReceiptRepository::class, fn ($app) => $app->make(YachayFactReceiptRepository::class));

$router->post(
    '/factReceipt',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceipt\\FactReceiptCreateController@__invoke'
    ]
);

$router->put(
    '/factReceipt',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceipt\\FactReceiptUpdateController@__invoke'
    ]
);

$router->get(
    '/factReceipt/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceipt\\FactReceiptIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->post(
    '/factReceipt/{Id}/send',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceipt\\FactReceiptSendController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factReceipt/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactReceipt\\FactReceiptListController@__invoke'
    ]
);
