<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\CashMovementDetail\Domain\CashMovementDetailRepository;
use App\Modules\CashMovementDetail\Infrastructure\MysqlCashMovementDetailRepository;

$app->bind(CashMovementDetailRepository::class, fn($app) => $app->make(MysqlCashMovementDetailRepository::class));

$router->get(
    '/cashMovement/{idCashMovement}/cashMovementDetail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementDetail@list'
    ]
)->where('idCashMovement', '[0-9]*');

$router->get(
    '/cashMovement/{idCashMovement}/cashMovementDetail/facture/{action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementDetail\\CashMovementDetailForFactureController@__invoke'
    ]
)->where('idCashMovement', '[0-9]*');

$router->get(
    '/invoice/{Id_Invoice}/cashMovementDetail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementDetail@invoiceList'
    ]
);
$router->get(
    '/invoice/{Id_Invoice}/cashMovementDetail/upgrade',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementDetail@listUpgrade'
    ]
);
$router->get(
    '/cashMovementDetailAll',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovementDetail@listAll'
    ]
);
