<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRepository;
use App\Modules\BookingTourPassenger\Infraestructure\MysqlBookingTourPassengerRepository;

$app->bind(BookingTourPassengerRepository::class, fn ($app) => $app->make(MysqlBookingTourPassengerRepository::class));

$router->get(
    '/bookingTourPassenger/{Id_BookingTourPassenger}/review',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTourPassenger\\Review@__invoke'
    ]
)->where('Id_BookingTourPassenger', '[0-9]*');

$router->get(
    '/bookingTourPassenger/{Id_BookingTourPassenger}/allItems',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTourPassenger\\BookingTourPassengerAllItemsController@__invoke'
    ]
)->where('Id_BookingTourPassenger', '[0-9]*');


$router->post(
    '/bookingTourPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour_Passenger@Insert'
    ]
);


$router->put(
    '/bookingTourPassenger/{Id}/partial',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTourPassenger\\BookingTourPassengerUpdatePartialController@__invoke'
    ]
)->where('Id', '[0-9]*');


$router->put(
    '/bookingTourPassenger/{Id}/cancel',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTourPassenger\\BookingTourPassengerCancelController@__invoke'
    ]
)->where('Id', '[0-9]*');


$router->put(
    '/bookingTourPassenger/status',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Tour_Passenger@Status'
    ]
);


$router->put(
    '/bookingTourPassenger/statusChange',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Tour_Passenger@StatusChange'
    ]
);

$router->put(
    '/bookingTourPassenger/hotel',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour_Passenger@Hotel'
    ]
);
$router->put(
    '/bookingTourPassenger/reportable',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour_Passenger@Reportable'
    ]
);
$router->put(
    '/bookingTourPassenger/remark',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour_Passenger@Remark'
    ]
);
$router->get(
    '/bookingTourPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour_Passenger@Selector'
    ]
);
$router->get(
    '/bookingTour/{Id_BookingTour}/bookingTourPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Booking_Tour_Passenger@List'
    ]
);
