<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Booking\Domain\BookingRepository;
use App\Modules\Booking\Infraestructure\MysqlBookingRepository;

$app->bind(BookingRepository::class, fn($app) => $app->make(MysqlBookingRepository::class));


$router->post(
    '/booking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Insert'
    ]
);

$router->post(
    '/booking/upgrade',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Upgrade'
    ]
);

$router->put(
    '/booking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Update'
    ]
);

$router->put(
    '/booking/delete',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Delete'
    ]
);

$router->put(
    '/booking/status',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Status'
    ]
);

$router->get(
    '/booking/searchBooking/',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking\\BookingFindByCodeController@__invoke'
    ]
);

$router->put(
    '/booking/manuallyConfirmed/',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking\\BookingUpdateManuallyConfirmedController@__invoke'
    ]
);

$router->get(
    '/booking/list',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@List'
    ]
);

$router->get(
    '/booking/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Index'
    ]
);

$router->get(
    '/booking/{Id}/sendMail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@SendMail'
    ]
);

$router->get(
    '/booking/search/book',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Search'
    ]
);

$router->get(
    '/booking/search/day',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@SearchDay'
    ]
);

$router->get(
    '/booking/search/passenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Search_Passenger'
    ]
);

$router->get(
    '/booking/history/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@History_List'
    ]
);

$router->get(
    '/bookingGetReport',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@GetReport'
    ]
);

// $router->put(
//     '/booking/admin',
//     [
//         'middleware' => 'Auth_Owner',
//         'uses' => 'Booking@UpdateAdmin'
//     ]
// );

$router->get(
    '/bookingYear',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking@Year_List'
    ]
);


$router->get(
    '/booking/report/excel',
    [
        'uses' => 'Booking\\BookingExportToExcelController@__invoke'
    ]
);

$router->put(
    '/booking/receipt',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Booking\\c_Receipt@__invoke'
    ]
);

$router->get(
    '/booking/report/report',
    [
        'uses' => 'Booking\\BookingReportController@__invoke'
    ]
);
