<?php

namespace App\Providers\ExcelTrainsReport;

use App\Http\Helpers\DateTime;

class TrainsCells
{

    private function titleMerge($text)
    {
        return [
            ['action' => 'wrap'],
            ['action' => 'border'],
            ['action' => 'print', 'text' => $text],
            ['action' => 'bold'],
            ['action' => 'merge', 'lines' => 1],
            ['action' => 'border'],
        ];
    }
    private function title($text)
    {
        return [['action' => 'wrap'], ['action' => 'border'], ['action' => 'print', 'text' => $text], ['action' => 'bold']];
    }
    private function titleNoBorders($text)
    {
        return [['action' => 'wrap'], ['action' => 'print', 'text' => $text], ['action' => 'bold'], ['action' => 'merge', 'lines' => 1],];
    }
    private function column($text)
    {
        return [['action' => 'wrap'], ['action' => 'border'], ['action' => 'print', 'text' => $text]];
    }
    private function columnMerge($text)
    {
        return [
            ['action' => 'wrap'],
            ['action' => 'border'],
            ['action' => 'print', 'text' => $text],
            ['action' => 'merge', 'lines' => 1],
            ['action' => 'border'],
        ];
    }



    private function createUpgrades(array $upgrades)
    {
        return array_merge(
            [
                [
                    $this->title('N°'),
                    $this->title('PASAJEROS'),
                    $this->title('TIPO DOC.'),
                    $this->title('DOCUMENTO'),
                    $this->title('INGRESO'),
                    $this->title('RETORNO'),
                    $this->title('PRECIO'),
                    $this->title('CÓDIGO'),

                    $this->title('ESTADO'),
                    $this->title('FECHA DE PAGO'),
                    $this->title('RESERVA'),
                    $this->title('FECHA DE RESERVA'),
                    $this->title('COMPAÑÍA'),
                    $this->title('VENDEDOR'),
                    $this->title('RESPONSABLE'),

                    $this->title('OBSERVACIONES'),
                ]
            ],
            array_map(
                function ($curr, $key) {
                    return [
                        $this->column($key + 1),
                        $this->column("$curr->Passenger_Name $curr->Passenger_LastName"),
                        $this->column($curr->TypeDocument_Name),
                        $this->column($curr->Passenger_NoDocument),
                        $this->column(
                            (self::purchased($curr) && self::onlyReturn($curr)) ?
                                DateTime::dateTimeTransform($curr->BookingUpgradePassenger_DateEntry) :
                                ''
                        ),
                        $this->column(
                            self::purchased($curr) ?
                                DateTime::dateTimeTransform($curr->BookingUpgradePassenger_Datereturn) :
                                '-'
                        ),
                        $this->column($curr->BookingUpgradePassenger_Amount),
                        $this->column($curr->BookingUpgradePassenger_Code),
                        $this->column(self::status($curr)),
                        $this->column(
                            self::purchased($curr) ?
                                $curr->BookingUpgradePassenger_DatePurchase :
                                '-'
                        ),
                        $this->column($curr->BookingTour_TourName),
                        $this->column($curr->BookingTour_DateStart),
                        $this->column($curr->BookingUpgradePassenger_Carrier),
                        $this->column($curr->Seller_Name),
                        $this->column($curr->Id_Admin != NULL ? "$curr->Admin_Name $curr->Admin_LastName" : ''),
                        $this->column($curr->BookingUpgradePassenger_Remark)
                    ];
                },
                $upgrades,
                array_keys($upgrades)
            )
        );
    }

    public static function status($bup)
    {
        switch ($bup->BookingUpgradePassenger_Status) {
            case 2:
                return 'COMPRADO';
            case 1:
                return 'PENDIENTE';
            default:
                return 'ANULADO';
        }
    }

    public static function purchased($bup)
    {
        return $bup->BookingUpgradePassenger_Status == 2;
    }

    public static function onlyReturn($bup)
    {
        return $bup->BookingUpgradePassenger_OnlyReturn == 2;
    }

    public function run($data, $oMetadata)
    {
        return $this->createUpgrades($data->Upgrade);
    }
}
