<?php

namespace App\Providers\ExcelGroupPassengerReport;

use App\Modules\Booking\Domain\ReportBooking;
use App\Providers\ExcelReport\Utils;

class GroupPassengerCells
{
    
    private function tableTitle($data)
    {
        $fnPrint = Utils::print($data[0]);
        $fnWidth = Utils::width($data[1]);
        return Utils::wrap(Utils::top(Utils::border(Utils::bold(Utils::center($fnPrint($fnWidth(Utils::cell())))))));
    }

    private function tableCellLeft($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::left($fnPrint(Utils::cell())))));
    }
    private function tableCellCenter($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::center($fnPrint(Utils::cell())))));
    }
    private function tableCellRight($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::right($fnPrint(Utils::cell())))));
    }

    private function getAllRows($data)
    {
        return array_map(fn($b, $index) => $this->getRow($b, $index), $data, array_keys($data));
    }

    private function getRow($passenger, $i)
    {
        return array_merge(
            [
                $this->tableCellLeft($i + 1),
                $this->tableCellLeft($passenger->Paquete),
                $this->tableCellLeft($passenger->Tour),
                $this->tableCellLeft($passenger->IdPass),
                $this->tableCellLeft($passenger->Pasajero),
                $this->tableCellLeft($passenger->Dia_ida),
                $this->tableCellLeft($passenger->Mes_ida),
                $this->tableCellLeft($passenger->Anho_ida),
                $this->tableCellLeft($passenger->Dia_retorno),
                $this->tableCellLeft($passenger->Mes_retorno),
                $this->tableCellLeft($passenger->Anho_retorno),
                $this->tableCellLeft($passenger->NoDias),
                $this->tableCellLeft($passenger->Sexo),
                $this->tableCellLeft($passenger->Edad),
                $this->tableCellLeft($passenger->Nacionalidad),
                $this->tableCellLeft($passenger->IdExt),
                $this->tableCellLeft($passenger->Tiene_TripAdvisor),
                $this->tableCellLeft($passenger->Trip_Count),
                $this->tableCellLeft($passenger->Trip_Dia_llenado),
                $this->tableCellLeft($passenger->Trip_Mes_llenado),
                $this->tableCellLeft($passenger->Trip_Anho_llenado),
                $this->tableCellLeft($passenger->Trip_Score),
                $this->tableCellLeft($passenger->Trip_Comentario),
                $this->tableCellLeft($passenger->Tiene_Review),
                $this->tableCellLeft($passenger->Dia_llenado),
                $this->tableCellLeft($passenger->Mes_llenado),
                $this->tableCellLeft($passenger->Anho_llenado),
                $this->tableCellLeft($passenger->Global_Score),
                $this->tableCellLeft($passenger->Guide_Name),
                $this->tableCellLeft($passenger->Guide_Score),
                $this->tableCellLeft($passenger->Guide_Comment),
                $this->tableCellLeft($passenger->SecondGuide_Name),
                $this->tableCellLeft($passenger->SecondGuide_Score),
                $this->tableCellLeft($passenger->SecondGuide_Comment),
                $this->tableCellLeft($passenger->Chef_Name),
                $this->tableCellLeft($passenger->Chef_Score),
                $this->tableCellLeft($passenger->Chef_Comment),
                $this->tableCellLeft($passenger->RestaurantMollepata_Name),
                $this->tableCellLeft($passenger->RestaurantMollepata_Score),
                $this->tableCellLeft($passenger->RestaurantMollepata_Comment),
                $this->tableCellLeft($passenger->RestaurantAguas_Name),
                $this->tableCellLeft($passenger->RestaurantAguas_Score),
                $this->tableCellLeft($passenger->RestaurantAguas_Comment),
                $this->tableCellLeft($passenger->Transport_Name),
                $this->tableCellLeft($passenger->Transport_Score),
                $this->tableCellLeft($passenger->Transport_Comment),
                $this->tableCellLeft($passenger->Horseman_Name),
                $this->tableCellLeft($passenger->Horseman_Score),
                $this->tableCellLeft($passenger->Horseman_Comment),
                $this->tableCellLeft($passenger->CampsSkyCamp_Name),
                $this->tableCellLeft($passenger->CampsSkyCamp_Score),
                $this->tableCellLeft($passenger->CampsSkyCamp_Comment),
                $this->tableCellLeft($passenger->CampsSkyView_Name),
                $this->tableCellLeft($passenger->CampsSkyView_Score),
                $this->tableCellLeft($passenger->CampsSkyView_Comment),
                $this->tableCellLeft($passenger->CampsJungle_Name),
                $this->tableCellLeft($passenger->CampsJungle_Score),
                $this->tableCellLeft($passenger->CampsJungle_Comment),
                $this->tableCellLeft($passenger->CampsAndean_Name),
                $this->tableCellLeft($passenger->CampsAndean_Score),
                $this->tableCellLeft($passenger->CampsAndean_Comment),
                $this->tableCellLeft($passenger->Hotel_Name),
                $this->tableCellLeft($passenger->Hotel_Score),
                $this->tableCellLeft($passenger->Hotel_Comment),
                $this->tableCellLeft($passenger->Recomend_Comment),
                $this->tableCellLeft($passenger->RecomendWhy_Comment),
                $this->tableCellLeft($passenger->Trip_Advisor),
                $this->tableCellLeft($passenger->Google),
                $this->tableCellLeft($passenger->Social_Network),
                $this->tableCellLeft($passenger->Referencias),
                $this->tableCellLeft($passenger->Otros),
                $this->tableCellLeft($passenger->Moments_Comment),
                $this->tableCellLeft($passenger->Comments_Suggestions),
                $this->tableCellLeft($passenger->GPGuide_Name),
                $this->tableCellLeft($passenger->GPSecondGuide_Name),
                $this->tableCellLeft($passenger->GPChef_Name),
                $this->tableCellLeft($passenger->GPRestaurantMollepata_Name),
                $this->tableCellLeft($passenger->GPRestaurantAguas_Name),
                $this->tableCellLeft($passenger->GPTransport_Name),
                $this->tableCellLeft($passenger->GPHorseman_Name),
                $this->tableCellLeft($passenger->GPCampsSkyCamp_Name),
                $this->tableCellLeft($passenger->GPCampsSkyView_Name),
                $this->tableCellLeft($passenger->GPCampsJungle_Name),
                $this->tableCellLeft($passenger->GPCampsAndean_Name),
                $this->tableCellLeft($passenger->GPHotel_Name),
            ]
        );
    }

    public function run($data, $metadata)
    {
        return array_merge(
            [
                array_merge(
                    array_map([$this,'tableTitle'], [
                        ['N°', 6],
                        ['Paquete', 15],
                        ['Tour', 15],
                        ['Id', 8],
                        ['Pasajero', 28],
                        ['D-Ida', 10],
                        ['M-Ida', 10],
                        ['A-Ida', 10],
                        ['D-Retorno', 12],
                        ['M-Retorno', 12],
                        ['A-Retorno', 12],
                        ['Días', 8],
                        ['Sexo', 8],
                        ['Edad', 8],
                        ['Nacionalidad', 14],
                        ['Id', 7],
                        ['Tiene TripAdvisor', 20],
                        ['Count', 8],
                        ['Trip D-Llenado', 18],
                        ['Trip M-Llenado', 18],
                        ['Trip A-Llenado', 18],
                        ['Trip Score', 12],
                        ['Trip Comentario', 48],
                        ['Tiene Review', 15],
                        ['D-Llenado', 12],
                        ['M-Llenado', 12],
                        ['A-Llenado', 12],
                        ['Global Score', 14],
                        ['Guide_Name', 25],
                        ['Guide_Score', 22],
                        ['Guide_Comment', 45],
                        ['SecondGuide_Name', 25],
                        ['SecondGuide_Score', 22],
                        ['SecondGuide_Comment', 45],
                        ['Chef_Name', 25],
                        ['Chef_Score', 22],
                        ['Chef_Comment', 45],
                        ['RestMollepata_Name', 25],
                        ['RestMollepata_Score', 22],
                        ['RestMollepata_Comment', 45],
                        ['RestAguas_Name', 25],
                        ['RestAguas_Score', 22],
                        ['RestAguas_Comment', 45],
                        ['Transport_Name', 25],
                        ['Transport_Score', 22],
                        ['Transport_Comment', 45],
                        ['Horseman_Name', 25],
                        ['Horseman_Score', 22],
                        ['Horseman_Comment', 45],
                        ['CampsSkyCamp_Name', 25],
                        ['CampsSkyCamp_Score', 22],
                        ['CampsSkyCamp_Comment', 45],
                        ['CampsSkyView_Name', 25],
                        ['CampsSkyView_Score', 22],
                        ['CampsSkyView_Comment', 45],
                        ['CampsJungle_Name', 25],
                        ['CampsJungle_Score', 22],
                        ['CampsJungle_Comment', 45],
                        ['CampsAndean_Name', 25],
                        ['CampsAndean_Score', 22],
                        ['CampsAndean_Comment', 45],
                        ['Hotel_Name', 25],
                        ['Hotel_Score', 22],
                        ['Hotel_Comment', 45],
                        ['Recommend_Comment', 45],
                        ['RecommendWhy_Comment', 45],
                        ['Trip_Advisor', 20],
                        ['Google', 20],
                        ['Social_Network', 20],
                        ['Referencias', 20],
                        ['Otros', 20],
                        ['Moments_Comment', 30],
                        ['Comments_Suggestions', 30],
                        ['GPGuide_Name', 25],
                        ['GPSecondGuide_Name', 25],
                        ['GPChef_Name', 25],
                        ['GPRestMollepata_Name', 25],
                        ['GPRestAguas_Name', 25],
                        ['GPTransport_Name', 25],
                        ['GPHorseman_Name', 25],
                        ['GPCampsSkyCamp_Name', 25],
                        ['GPCampsSkyView_Name', 25],
                        ['GPCampsJungle_Name', 25],
                        ['GPCampsAndean_Name', 25],
                        ['GPHotel_Name', 25],
                    ]),
                ),
            ],
            $this->getAllRows($data)
        );
    }
}
