<?php

namespace App\Providers\ExcelCashMovementLastReport;

use App\Providers\ExcelReport\ExcelReport;

class ExcelCashMovementLastReport
{

    public function exportToExcel($oData)
    {
        $report = new ExcelReport();
        $id_book = 0;
        foreach ($oData as $cashmov) {
            foreach ($cashmov->CashMovementDetail as $detail) {
                $id_detail = $detail->Id_CashMovementDetail;
                $detail->cant = 0;
                if ($id_book != $detail->Id_Booking) {
                    $id_book = $detail->Id_Booking;
                    foreach ($cashmov->CashMovementDetail as $d) {
                        if ($id_book == $d->Id_Booking) {
                            $detail->cant++;
                        }
                    }
                }
            }
            $id_book = 0;
        }

        $report->exportToExcel(
            [$oData],
            (object)[
                'title' => 'MOVIMIENTOS DE CAJA',
                'rowLength' => 1
            ],
            [
                new ColumnsWidth(),
                new CashMovementCells()
            ],
        );
    }
}
