<?php

namespace App\Modules\WebContactMessageDetail\Infraestructure;

use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetail;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailRepository;
use App\Modules\WebContactMessageDetail\Domain\IdWebContactMessageDetail;

class MysqlWebContactMessageDetailRepository implements WebContactMessageDetailRepository
{

    public function find(IdWebContactMessage $idWebContactMessage, string $action)
    {
        return RequestChecker::requestSelect(
            'CALL sp_web_contact_message_detail_list(?,?,@sts,@cod,@msg)',
            [
                $idWebContactMessage->value(),
                $action
            ]
        );
    }

    public function index(IdWebContactMessageDetail $id)
    {
        return RequestChecker::requestSelect(
            'CALL sp_web_contact_message_detail_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(WebContactMessageDetail $value)
    {
        return RequestChecker::requestInsert(
            'CALL sp_web_contact_message_detail_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->dateStart()->value(),
                $value->package()->value(),
                $value->status()->value(),
                $value->idWebContactMessage()->value(),
                $value->idPackage()->value(),
            ]
        );
    }

    public function update(WebContactMessageDetail $value)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_web_contact_message_detail_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->dateStart()->value(),
                $value->package()->value(),
                $value->idWebContactMessage()->value(),
            ]
        );
    }

    public function delete(IdWebContactMessageDetail $id)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_web_contact_message_detail_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
