<?php

namespace App\Modules\WebContactMessageDetail\Application\Index;

use App\Modules\WebContactMessageDetail\Application\Index\IndexWebContactMessageDetailQueryResponse;
use App\Modules\WebContactMessageDetail\Domain\IdWebContactMessageDetail;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailRepository;

final class WebContactMessageDetailIndexer
{
    public function __construct(private WebContactMessageDetailRepository $repository)
    {
    }

    public function __invoke(IdWebContactMessageDetail $idWebContactMessageDetail): IndexWebContactMessageDetailQueryResponse
    {
        return new IndexWebContactMessageDetailQueryResponse($this->repository->index($idWebContactMessageDetail));
    }
}
