<?php

namespace App\Modules\WebContactMessageDetail\Application\Index;

use App\Modules\WebContactMessageDetail\Domain\IdWebContactMessageDetail;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexWebContactMessageDetailQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageDetailIndexer $inserter)
    {
    }

    public function __invoke(IndexWebContactMessageDetailQuery $query): IndexWebContactMessageDetailQueryResponse
    {
        return $this->inserter->__invoke(new IdWebContactMessageDetail($query->getId()));
    }
}
