<?php

namespace App\Modules\WebContactMessage\Domain;

use App\Modules\Country\Domain\IdCountry;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\WebContact\Domain\IdWebContact;

/**
 * Status in the group for filtering and display
 */
class WebContactMessage
{

    public function __construct(
        private WebContactMessageDateDeparture $dateDeparture,
        private WebContactMessageDateSend $dateSend,
        private WebContactMessageDateReception $dateReception,
        private WebContactMessageName $name,
        private WebContactMessageLastName $lastName,
        private WebContactMessageEmail $email,
        private WebContactMessageCountry $country,
        private WebContactMessageCountryCurrent $countryCurrent,
        private WebContactMessagePhoneCode $phoneCode,
        private WebContactMessagePhone $phone,
        private IdCountry $idCountry,
        private IdCountry $idCountryCurrent,
        private WebContactMessageMessage $message,
        private WebContactMessageAdults $adults,
        private WebContactMessageChildren $children,
        private WebContactMessageSubscription $subscription,
        private WebContactMessageOrigin $origin,
        private WebContactMessageType $type,
        private WebContactMessageStatus $status,
        private IdWebContact $idWebContact,
        private IdLanguage $idLanguage,
        private ?IdWebContactMessage $id = null,
    ) {
    }

    public function id(): IdWebContactMessage
    {
        return $this->id;
    }

    public function dateDeparture(): WebContactMessageDateDeparture {
        return $this->dateDeparture;
    }

    public function dateSend(): WebContactMessageDateSend {
        return $this->dateSend;
    }

    public function dateReception(): WebContactMessageDateReception {
        return $this->dateReception;
    }

    public function name(): WebContactMessageName {
        return $this->name;
    }

    public function lastName(): WebContactMessageLastName {
        return $this->lastName;
    }

    public function email(): WebContactMessageEmail {
        return $this->email;
    }

    public function country(): WebContactMessageCountry {
        return $this->country;
    }

    public function countryCurrent(): WebContactMessageCountryCurrent {
        return $this->countryCurrent;
    }

    public function phoneCode(): WebContactMessagePhoneCode {
        return $this->phoneCode;
    }

    public function phone(): WebContactMessagePhone {
        return $this->phone;
    }

    public function idCountry(): IdCountry {
        return $this->idCountry;
    }

    public function idCountryCurrent(): IdCountry {
        return $this->idCountryCurrent;
    }

    public function message(): WebContactMessageMessage
    {
        return $this->message;
    }

    public function adults(): WebContactMessageAdults
    {
        return $this->adults;
    }

    public function children(): WebContactMessageChildren
    {
        return $this->children;
    }

    public function subscription(): WebContactMessageSubscription
    {
        return $this->subscription;
    }

    public function origin(): WebContactMessageOrigin
    {
        return $this->origin;
    }

    public function type(): WebContactMessageType
    {
        return $this->type;
    }

    public function status(): WebContactMessageStatus
    {
        return $this->status;
    }

    public function idWebContact(): IdWebContact
    {
        return $this->idWebContact;
    }

    public function idLanguage(): IdLanguage
    {
        return $this->idLanguage;
    }
}
