<?php

namespace App\Modules\WebContactMessage\Application\Update;

use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContactMessage\Domain\UpdateWebContactMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageAdults;
use App\Modules\WebContactMessage\Domain\WebContactMessageChildren;
use App\Modules\WebContactMessage\Domain\WebContactMessageMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageSubscription;

final class UpdateWebContactMessageQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageUpdater $updater)
    {
    }

    public function __invoke(UpdateWebContactMessageQuery $query): UpdateWebContactMessageQueryResponse
    {
        $model = new UpdateWebContactMessage(
            new WebContactMessageMessage($query->message()),
            new WebContactMessageAdults($query->adults()),
            new WebContactMessageChildren($query->children()),
            new WebContactMessageSubscription($query->subscription()),
            new WebContactMessageStatus($query->status()),
            new IdWebContact($query->idWebContact()),
            new IdWebContactMessage($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
