<?php

namespace App\Modules\WebContact\Application\Find;

use App\Modules\WebContact\Application\Find\FindWebContactQueryResponse;
use App\Modules\WebContact\Domain\WebContactEmail;
use App\Modules\WebContact\Domain\WebContactRepository;

final class WebContactFinder
{
    public function __construct(private WebContactRepository $repository)
    {
    }

    public function __invoke(WebContactEmail $email): FindWebContactQueryResponse
    {
        return new FindWebContactQueryResponse($this->repository->search($email));
    }
}
