<?php

namespace App\Modules\WebContact\Application\Delete;

use App\Modules\WebContact\Application\Delete\WebContactDeleterResponse;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContact\Domain\WebContactRepository;

final class WebContactDeleter
{
    public function __construct(private WebContactRepository $repository)
    {
    }

    public function __invoke(IdWebContact $idWebContact): DeleteWebContactQueryResponse
    {
        return new DeleteWebContactQueryResponse($this->repository->delete($idWebContact));
    }
}
