<?php

namespace App\Modules\WebContact\Application\Delete;

use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteWebContactQueryHandler implements QueryHandler
{
    public function __construct(private WebContactDeleter $inserter)
    {
    }

    public function __invoke(DeleteWebContactQuery $query): DeleteWebContactQueryResponse
    {
        return $this->inserter->__invoke(new IdWebContact($query->getId()));
    }
}
