<?php

namespace App\Modules\StatusGroup\Application\Update;

use App\Modules\StatusGroup\Domain\IdStatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroupName;
use App\Modules\StatusGroup\Domain\StatusGroupStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\StatusGroup\Domain\StatusGroupAbrv;
use App\Modules\StatusGroup\Domain\StatusGroupColor;

final class UpdateStatusGroupQueryHandler implements QueryHandler
{
    public function __construct(private StatusGroupUpdater $updater)
    {
    }

    public function __invoke(UpdateStatusGroupQuery $query): UpdateStatusGroupQueryResponse
    {
        $model = new StatusGroup(
            new StatusGroupName($query->name()),
            new StatusGroupAbrv($query->abrev()),
            new StatusGroupColor($query->color()),
            new StatusGroupStatus($query->status()),
            new IdStatusGroup($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
