<?php

namespace App\Modules\Shared\Infraestructure;

use App\Modules\Shared\Domain\InsertResponse;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use Illuminate\Support\Facades\DB;

class Requester
{

    public static function requestSelect($query, array $data)
    {
        $resData = DB::select(
            $query,
            $data
        );

        $q = 'SELECT @sts as Response_Status, @cod as Response_Code, @msg as Response_Message, @id as Response_Id';
        $res = DB::select($q);
        $turn = [];
        $turn["Response_Status"]           = $res[0]->Response_Status;
        $turn["Response_Code"]             = $res[0]->Response_Code;
        $turn["Response_Domain"]           = 'global';
        $turn["Response_Message"]          = $res[0]->Response_Message;
        $turn["Response_Data"]             = null;
        $turn["Response_Error_Message"]    = $res[0]->Response_Status != 200 ? $query . ': ' . $res[0]->Response_Message : '';
        $turn["Response_Error_Reason"]     = $res[0]->Response_Status != 200 ? $query . ': ' . $res[0]->Response_Message : '';

        if ($res[0]->Response_Status != 200) {
            throw new InvalidRequestException($turn);
        }

        $turn["Response_Data"]             = $resData;

        return $turn;
    }

    public static function requestInsert($query, array $data)
    {
        DB::select($query, $data);
        $q = 'SELECT @sts as Response_Status, @cod as Response_Code, @msg as Response_Message, @id as Response_Id';
        $res = DB::select($q);
        $turn = [];
        $turn["Response_Status"]           = $res[0]->Response_Status;
        $turn["Response_Code"]             = $res[0]->Response_Code;
        $turn["Response_Domain"]           = 'global';
        $turn["Response_Message"]          = $res[0]->Response_Message;
        $turn["Response_Data"]             = null;
        $turn["Response_Error_Message"]    = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        $turn["Response_Error_Reason"]     = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        if ($res[0]->Response_Status != 200) {
            throw new InvalidRequestException($turn);
        }
        $turn["Response_Data"]             = [ 'Id' => $res[0]->Response_Id ];
        return $turn;
    }

    public static function buildActionResponse($response) 
    {
        $built = [];
        $built["Response_Status"]           = $response[0]->Response_Status;
        $built["Response_Code"]             = $response[0]->Response_Code;
        $built["Response_Domain"]           = 'global';
        $built["Response_Message"]          = $response[0]->Response_Message;
        $built["Response_Data"]             = null;
        $built["Response_Error_Message"]    = $response[0]->Response_Status != 200 ? $response[0]->Response_Message : '';
        $built["Response_Error_Reason"]     = $response[0]->Response_Status != 200 ? $response[0]->Response_Message : '';
        if ($response[0]->Response_Status != 200) {
            throw new InvalidRequestException($built);
        }
        if (isset($response[0]->Response_Id)) {
            $built["Response_Data"]             = [ 'Id' => $response[0]->Response_Id ];
        }
        return $built;
    }

    public static function requestInsertAlter($query, array $data)
    {
        DB::select($query, $data);
        $q = 'SELECT @sts as Response_Status, @cod as Response_Code, @msg as Response_Message, @id as Response_Id';
        $res = DB::select($q);
        $turn = [];
        $turn["Response_Status"]           = $res[0]->Response_Status;
        $turn["Response_Code"]             = $res[0]->Response_Code;
        $turn["Response_Domain"]           = 'global';
        $turn["Response_Message"]          = $res[0]->Response_Message;
        $turn["Response_Data"]             = null;
        $turn["Response_Error_Message"]    = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        $turn["Response_Error_Reason"]     = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        if ($res[0]->Response_Status != 200) {
            throw new InvalidRequestException($turn);
        }
        return new InsertResponse(
            $res[0]->Response_Id,
            $res[0]->Response_Status,
            $res[0]->Response_Code,
            $res[0]->Response_Message,
        );
    }

    public static function requestGeneric($query, array $data, array $indexes)
    {
        $str = '';
        foreach ($indexes as $key => $index) {
            $str .= ", $index as $key";
        }
        DB::select($query, $data);
        
        $res = DB::select('SELECT @sts as Response_Status, @cod as Response_Code, @msg as Response_Message' . $str);
        
        $turn = [];
        $turn["Response_Status"]           = $res[0]->Response_Status;
        $turn["Response_Code"]             = $res[0]->Response_Code;
        $turn["Response_Domain"]           = 'global';
        $turn["Response_Message"]          = $res[0]->Response_Message;
        $turn["Response_Data"]             = null;
        $turn["Response_Error_Message"]    = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        $turn["Response_Error_Reason"]     = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        if ($res[0]->Response_Status != 200) {
            throw new InvalidRequestException($turn);
        }
         
        unset($res[0]->Response_Status, $res[0]->Response_Code, $res[0]->Response_Message);
        $turn["Response_Data"]             = (array)$res[0];
        return $turn;
    }

    public static function generateResponse($res, $domain)
    {
        $turn = [];
        $turn["Response_Status"]           = $res[0]->Response_Status;
        $turn["Response_Code"]             = $res[0]->Response_Code;
        $turn["Response_Domain"]           = $domain;
        $turn["Response_Message"]          = $res[0]->Response_Message;
        $turn["Response_Data"]             = null;
        $turn["Response_Error_Message"]    = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        $turn["Response_Error_Reason"]     = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        return $turn;
    }

    public static function requestUpdate($query, array $data)
    {
        DB::select($query, $data);
        $res = DB::select('SELECT @sts as Response_Status, @cod as Response_Code, @msg as Response_Message');
        $turn = [];
        $turn["Response_Status"]           = $res[0]->Response_Status;
        $turn["Response_Code"]             = $res[0]->Response_Code;
        $turn["Response_Domain"]           = 'global';
        $turn["Response_Message"]          = $res[0]->Response_Message;
        $turn["Response_Data"]             = null;
        $turn["Response_Error_Message"]    = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        $turn["Response_Error_Reason"]     = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';

        if ($res[0]->Response_Status != 200) {
            throw new InvalidRequestException($turn);
        }
        $turn["Response_Data"]             = [ ];
        return $turn;
    }
}
