<?php

namespace App\Modules\Shared\Infraestructure\QueryList;

use App\Modules\Shared\Domain\QueryList\ListInput;
use App\Modules\Shared\Domain\QueryList\ListValidator;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class LaravelListValidator implements ListValidator
{

    public const FIND = [
        'page'          => 'string',
        'amount'        => 'string',
        'filter'        => 'string|max:250'
    ];

    private Request $request;

    public function __construct(
        Request $request
    ) {
        $this->request = $request;
    }

    public function __invoke(array $validators, string $domain): ListInput
    {
        $validator = new LaravelValidator();
        $validator->validate($this->request->all(), $domain, $validators);
        $page = $this->request->input('page', '1');
        $amount = $this->request->input('amount', '20');
        return new ListInput($page, $amount, $this->request->input('filter', ''));
    }
}
