<?php

namespace App\Modules\Shared\Infraestructure\Command;

use App\Modules\Shared\Domain\Bus\Command\Command;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;

final class InMemoryCommandBus implements CommandBus
{

    public function __construct()
    {
    }

    public function dispatch(Command $command)
    {
        $className = get_class($command);
        $className = explode('Command', $className)[0];
        $classHandler = $className . 'Handler';
        if (!class_exists($classHandler)) {
            throw new BadRequestException('Handler doesn\'t exists');
        }

        return (app()->make($classHandler))($command);
    }
}
