<?php

namespace App\Modules\Shared\Infraestructure;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Exceptions\ActionRequestException;
use App\Modules\Shared\Exceptions\BasicRequestException;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Exceptions\ValidateException;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

final class BasicExceptionHandler
{
    public static function handleException($exception)
    {
        if ($exception instanceof NotFoundHttpException) {
            $response["Response_Status"]           = 404;
            $response["Response_Code"]             = 404;
            $response["Response_Domain"]           = "global";
            $response["Response_Message"]          = "Endpoint not found";
            $response["Response_Data"]             = null;
            $response["Response_Error_Message"]    = "Not found";
            $response["Response_Error_Reason"]     = "Endpoint not found";
            return ResponseBuilder::Response($response);
        } elseif ($exception instanceof MethodNotAllowedHttpException) {
            $response["Response_Status"]           = 405;
            $response["Response_Code"]             = 405;
            $response["Response_Domain"]           = "global";
            $response["Response_Message"]          = "Method not allowed";
            $response["Response_Data"]             = null;
            $response["Response_Error_Message"]    = "Method not allowed";
            $response["Response_Error_Reason"] = "The HTTP verb is not supported by the URL endpoint used in the request";
            return ResponseBuilder::Response($response);
        } elseif ($exception instanceof InvalidRequestException) {
            $response = $exception->getResponse();
            $response["Response_Error_Reason"] = $exception->getTraceAsString();
            return ResponseBuilder::Response($response);
        } elseif ($exception instanceof ValidateException) {
            return ResponseBuilder::Response($exception->getResponse());
        } elseif ($exception instanceof ActionRequestException) {
            $response = [];
            $response["Response_Status"]            = $exception->getResponse()->Response_Status;
            $response["Response_Code"]              = $exception->getResponse()->Response_Code;
            $response["Response_Domain"]            = '';
            $response["Response_Message"]           = $exception->getResponse()->Response_Message;
            $response["Response_Data"]              = null;
            $response["Response_Error_Message"]     = $exception->getResponse()->Response_Message;
            $response["Response_Error_Reason"]      = $exception->getResponse()->Response_Reason;
            return ResponseBuilder::Response($response);
        } elseif ($exception instanceof BasicRequestException) {
            $response = [];
            $response["Response_Status"]            = $exception->getStatus();
            $response["Response_Code"]              = $exception->getCode();
            $response["Response_Domain"]            = '';
            $response["Response_Message"]           = $exception->getMessage();
            $response["Response_Data"]              = null;
            $response["Response_Error_Message"]     = $exception->getMessage();
            $response["Response_Error_Reason"]      = $exception->getMessage();
            return ResponseBuilder::Response($response);
        } else {
            $code = env('PRODUCTION', '0') == '0' ? $exception->getCode() : '500';
            $message = env('PRODUCTION', '0') == '0' ? $exception->getMessage() : 'SERVER ERROR';
            $trace = env('PRODUCTION', '0') == '0' ? $exception->getTraceAsString() : 'SERVER ERROR';
            $response = [];
            $response["Response_Status"]            = 500;
            $response["Response_Code"]              = $code;
            $response["Response_Domain"]            = '';
            $response["Response_Message"]           = $message;
            $response["Response_Data"]              = null;
            $response["Response_Error_Message"]     = $message;
            $response["Response_Error_Reason"]      = $trace;
            return ResponseBuilder::Response($response);
        }
    }
}
