<?php

declare(strict_types=1);

namespace App\Modules\Shared\Domain\ValueObject;

abstract class NumericValueObject {
    
    protected float $value;
    
    public function __construct(float $value) {
        $this->value = $value;
    }

    public function value():float { return $this->value; }

    public function isBiggerThan(NumericValueObject $other):bool {
        return $this->value() > $other->value();
    }
}
