<?php

namespace App\Modules\Shared\Domain\ValueObject;

use DateInterval;
use DateTime;
use InvalidArgumentException;
use Stringable;

class DateTimeValueObject implements Stringable
{

    protected static $format = 'Y-m-d H:i:s';
    protected DateTime $value;

    public static function now()
    {
        return new static(date(self::$format));
    }

    public static function reduceDatetimeToPeru(self $datetime)
    {
        $interval = new DateInterval('PT5H');
        $datetime->value->sub($interval);
        return $datetime;
    }

    public static function upgradeDatetimeFromPeruToUTC(self $datetime)
    {
        $interval = new DateInterval('PT5H');
        $datetime->value->add($interval);
        return $datetime;
    }

    public function __construct(string $value)
    {
        $this->ensureIsValidDate($value);
        $this->value = DateTime::createFromFormat(self::$format, $value);
    }

    public function setTime(int $hour, int $minute, int $second = 0): void
    {
        $this->value->setTime($hour, $minute, $second);
    }

    public function value($format = null): string
    {
        return $this->value->format($format ?? self::$format);
    }

    public function addInterval(string $interval)
    {
        $this->value->add(new DateInterval($interval));
    }

    public function __toString(): string
    {
        return $this->value();
    }

    private function ensureIsValidDate(string $date): void
    {
        $dt = DateTime::createFromFormat(self::$format, $date);
        if (!$dt || $dt->format(self::$format) !== $date) {
            throw new InvalidArgumentException(sprintf('<%s> does not allow the value <%s>.', static::class, $date));
        }
    }
}
