<?php

declare(strict_types=1);

namespace App\Modules\Shared\Domain\ValueObject;

abstract class BooleanValueObject extends EnumValueObject
{

    public const VALUE_FALSE = 1;
    public const VALUE_TRUE = 2;

    public function __construct($value)
    {
        parent::__construct($value);
    }

    public static function values()
    {
        return [
            self::VALUE_FALSE,
            self::VALUE_TRUE
        ];
    }
}
