<?php

namespace App\Modules\Shared\Domain;

use DateInterval;
use DateTime;

class DateUtils
{
    public static function toIsoDate(\DateTime $date): string
    {
        return $date->format('Y-m-d');
    }

    /**
     * @param string $oldDate Date in format Y-m-d
     * @param string $newDate Date in format Y-m-d
     */
    public static function dateDiferenceInDays(string $oldDate, string $newDate): int
    {
        $oldDate = \DateTime::createFromFormat('Y-m-d', $oldDate);
        $newDate = \DateTime::createFromFormat('Y-m-d', $newDate);
        $diff = $newDate->diff($oldDate);
        return $diff->invert ? -$diff->days : $diff->days;
    }

    /**
     * @param string $date Date in format Y-m-d
     * @param int $days Number of days positive or negative
     */
    public static function changeDate(string $date, int $days): string
    {
        $date = DateTime::createFromFormat('Y-m-d H:i:s', $date);
        if ($days > 0) {
            $date->add(new DateInterval('P' . $days . 'D'));
        } else {
            $date->sub(new DateInterval('P' . abs($days) . 'D'));
        }
        return $date->format('Y-m-d');
    }
}
