<?php

namespace App\Modules\Shared\Domain;

class DataHandlerService
{

    public function __construct()
    {
    }

    public function flatIndexGroup($elementsName)
    {
        return function ($groups) use ($elementsName) {
            
            return array_reduce(
                array_keys(get_object_vars($groups)),
                function (array $c, $key) use ($elementsName, $groups) {
                    $c[] = (object)[
                        'element' => $groups->{$key}[0],
                        $elementsName => $groups->{$key}
                    ];
                    return $c;
                },
                []
            );
        };
    }

    public function groupDataBy($data, $index)
    {
        return array_reduce($data, function ($carry, $e) use ($index) {
            if (!isset($e->{$index})) {
                return $carry;
            }
            if (!isset($carry->{$e->{$index}})) {
                $carry->{$e->{$index}} = [];
            }
            $carry->{$e->{$index}}[] = $e;
            return $carry;
        }, (object)[]);
    }

    // public unIndex = <T>(data: { [x: string]: T; }) => {
    // return Object.keys(data).reduce((c, key) => {
    //     c.push(data[key]);
    //     return c;
    // }, [] as T[]);
    // }

    // public indexDataBy = <T extends { [ind: string]: any }>(data: T[], ind: string) => {
    // return data.reduce((c, e) => !e[ind] ? c : { ...c, [e[ind]]: e }, {} as { [ind: string]: T });
    // }

    // public unaryGroupDataBy = (index: string) => <T>(data: T[]): { [key: string]: T[] } => {
    // return data.reduce((carry, e) => {
    //     if (!e[index]) {
    //     return carry;
    //     }
    //     if (!carry[e[index]]) {
    //     carry[e[index]] = [];
    //     }
    //     carry[e[index]].push(e);
    //     return carry;
    // }, {});
    // }

    // public unaryIndexDataBy = (index: string) => (data: { [ind: string]: any }[]) => this.indexDataBy(data, index);
}
