<?php

namespace App\Modules\Shared\Domain\Criteria;

class AndSpecification implements Specification
{
    public function __construct(
        private Specification $firstSpecification,
        private Specification $secondSpecification
    ) {
    }

    public function isSatisfiedBy(mixed $element): bool
    {
        return $this->firstSpecification->isSatisfiedBy($element) && $this->secondSpecification->isSatisfiedBy($element);
    }
}
