<?php

namespace App\Modules\Shared\Domain\Aggregate;

class AggregateAttribute
{
    public function __construct(
        private string $attribute,
        private string $objectName,
        private string $column,
        private string $attributeType = 'column'
    ) {
    }

    public function attribute(): string
    {
        return $this->attribute;
    }

    public function objectName(): string
    {
        return $this->objectName;
    }

    public function column(): string
    {
        return $this->column;
    }

    public function attributeType(): string
    {
        return $this->attributeType;
    }
}
