<?php

namespace App\Modules\ReviewSession\Application;

use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\ReviewSession\Domain\ReviewSessionRepository;
use App\Modules\ReviewSession\Domain\ReviewSessionToken;

final class ReviewSessionFinder
{
    public function __construct(
        private ReviewSessionRepository $repository
    ) {
    }

    public function __invoke(ReviewSessionToken $token)
    {
        return $this->repository->findToken($token);
    }
}
