<?php

namespace App\Modules\ReviewNotification\Domain;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Admin\Domain\IdAdmin;

class InsertReviewNotification
{

    /** constructor */
    public function __construct(
        private ReviewNotificationDescription $description,
        private ReviewNotificationStatus $status,
        private IdGroupPassenger $idGroupPassenger,
        private IdAdmin $idAdminCreate,
        private IdReviewNotification $idReviewNotificationParent
    ) {
    }
    public function getDescription(): ReviewNotificationDescription
    {
        return $this->description;
    }
    public function getStatus(): ReviewNotificationStatus
    {
        return $this->status;
    }
    public function getIdGroupPassenger(): IdGroupPassenger
    {
        return $this->idGroupPassenger;
    }
    public function getIdAdmin(): IdAdmin
    {
        return $this->idAdminCreate;
    }
    public function getIdReviewNotificationParent(): IdReviewNotification
    {
        return $this->idReviewNotificationParent;
    }
}
