<?php

namespace App\Modules\ReviewNotification\Application\Accept;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ReviewNotificationAccepterQuery implements Query
{
    public function __construct(
        private int $id,
        private string $response,
        private int $idAdmin
    ) {
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function getResponse(): string
    {
        return $this->response;
    }
    public function getIdAdmin(): int
    {
        return $this->idAdmin;
    }
}
