<?php
namespace App\Modules\ReviewDetail\Application\Find;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\ReviewDetail\Application\ReviewDetailResponse;
use App\Modules\ReviewDetail\Application\ReviewDetailsResponse;
use App\Modules\ReviewDetail\Domain\ReviewDetailFindRepository;

class ReviewDetailFinder
{
    public function __construct(
        private ReviewDetailFindRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(IdGroupPassenger $id)
    {
        // return new ReviewDetailsResponse(...array_map(
        //     $this->toResponse(),
        //     $this->repository->find($id)['Response_Data']
        // ));
        return $this->repository->find($id);
    }

    private function toResponse(): callable
    {
        return static fn($response) => new ReviewDetailResponse(
            $response->Id_PassengerReview,
            $response->PassengerReview_Date,
            $response->PassengerReview_Answered,
            $response->PassengerReview_Score,
            $response->PassengerReview_Comment,
            $response->PassengerReview_Values,
            $response->Id_BookingTourPassenger,
            $response->Id_Provider,
            $response->Provider_BusinessName,
            $response->Provider_TradeName,
            $response->Provider_NoDocument,
            $response->Provider_Address,
            $response->Provider_Phone,
            $response->Provider_Status,
            $response->Provider_ScoreTotal,
            $response->Provider_ScoreCant,
            $response->Question_Name,
            $response->Question_Abrv,
            $response->Question_Status,
            $response->Question_Type,
            $response->Id_TypeProvider
        );
    }
}
