<?php

namespace App\Modules\QuestionTypeProvider\Domain;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

class QuestionTypeProvider
{

    public function __construct(
        private QuestionTypeProviderShow $show,
        private QuestionTypeProviderForPassenger $forPassenger,
        private QuestionTypeProviderStatus $status,
        private IdProvider $idProvider,
        private IdTypeProvider $idTypeProvider,
        private ?IdQuestionTypeProvider $id = null
    ) {
    }

    public function getId(): IdQuestionTypeProvider
    {
        return $this->id;
    }
    public function getShow(): QuestionTypeProviderShow
    {
        return $this->show;
    }
    public function getForPassenger(): QuestionTypeProviderForPassenger
    {
        return $this->forPassenger;
    }
    public function getStatus(): QuestionTypeProviderStatus
    {
        return $this->status;
    }
    public function getIdProvider(): IdProvider
    {
        return $this->idProvider;
    }
    public function getIdTypeProvider(): IdTypeProvider
    {
        return $this->idTypeProvider;
    }
}
