<?php

namespace App\Modules\QuestionTypeProvider\Application\List;

use App\Modules\Question\Domain\IdQuestion;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class QuestionTypeProviderListerQueryHandler implements QueryHandler
{
    public function __construct(private QuestionTypeProviderLister $lister)
    {
    }

    public function __invoke(QuestionTypeProviderListerQuery $query): QuestionTypeProviderListerResponse
    {
        return $this->lister->__invoke(
            new IdQuestion($query->getIdQuestion()),
            $query->getAction()
        );
    }
}
