<?php

namespace App\Modules\ProviderTypeProvider\Application\Update;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\ProviderTypeProvider\Domain\IdProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderDOB;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderEmail;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderExtras;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderGender;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderImgDocument1;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderInfoStatus;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderLastName;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderName;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderNoDocument;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderPhone;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderRestriction;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

final class ProviderTypeProviderUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private ProviderTypeProviderUpdater $updater)
    {
    }

    public function __invoke(ProviderTypeProviderUpdaterQuery $query): ProviderTypeProviderUpdaterResponse
    {
        $model = new ProviderTypeProvider(
            new ProviderTypeProviderStatus($query->status()),
            new IdProvider($query->idProvider()),
            new IdTypeProvider($query->idTypeProvider()),
            new IdProviderTypeProvider($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
