<?php

namespace App\Modules\ProviderTypeProvider\Application\Index;

use App\Modules\ProviderTypeProvider\Domain\IdProviderTypeProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ProviderTypeProviderIndexerQueryHandler implements QueryHandler
{
    public function __construct(private ProviderTypeProviderIndexer $inserter)
    {
    }

    public function __invoke(ProviderTypeProviderIndexerQuery $query): ProviderTypeProviderIndexerResponse
    {
        return $this->inserter->__invoke(new IdProviderTypeProvider($query->getId()));
    }
}
