<?php

namespace App\Modules\PaxInformationPassenger\Domain;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\PaxInformation\Domain\IdPaxInformation;

final class PaxInformationPassenger {

    private PaxInformationPassengerStatus $status;
    private IdPaxInformation $idPaxInformation;
    private IdPassenger $idPassenger;
    private IdPaxInformationPassenger $id;

    public function __construct(
        PaxInformationPassengerStatus $status,
        IdPaxInformation $idPaxInformation,
        IdPassenger $idPassenger,
        IdPaxInformationPassenger $id
    ) {
        $this->status = $status;
        $this->idPaxInformation = $idPaxInformation;
        $this->idPassenger = $idPassenger;
        $this->id = $id;
    }

    public function status():PaxInformationPassengerStatus { return $this->status; }
    public function idPaxInformation():IdPaxInformation { return $this->idPaxInformation; }
    public function idPassenger():IdPassenger { return $this->idPassenger; }
    public function id():IdPaxInformationPassenger { return $this->id; }

}