<?php

namespace App\Modules\PaxInformation\Application;

use App\Modules\PaxInformation\Domain\PaxInformationSearchTokenRepository;
use App\Modules\PaxInformation\Domain\PaxInformationToken;

class PaxInformationTokenEmptyFinder {

    private PaxInformationSearchTokenRepository $repository;

    public function __construct(PaxInformationSearchTokenRepository $repository) {
        $this->repository = $repository;
    }

    public function __invoke (PaxInformationToken $token) {
        return $this->repository->findToken($token);
    }
}