<?php

namespace App\Modules\PaxInformation\Application\Insert;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\PaxInformation\Application\Insert\PaxInformationInsert;
use App\Modules\PaxInformation\Application\Insert\PaxInformationInsertCommand;
use App\Modules\PaxInformation\Domain\PaxInformationDateExpire;
use App\Modules\PaxInformation\Domain\PaxInformationDescription;
use App\Modules\PaxInformation\Domain\PaxInformationRemaining;
use App\Modules\PaxInformation\Domain\PaxInformationStatus;

final class PaxInformationInsertHandler
{
    
    private PaxInformationInsert $paxInformationInsert;
    

    public function __construct(
        PaxInformationInsert $action
    ) {
        $this->paxInformationInsert = $action;
    }

    private function action(...$args)
    {
        return $this->paxInformationInsert->__invoke(...$args);
    }

    public function __invoke(PaxInformationInsertCommand $query): array
    {
        $description = new PaxInformationDescription($query->description());
        $remaining = new PaxInformationRemaining($query->remaining());
        $expire = new PaxInformationDateExpire($query->expire());
        $status = new PaxInformationStatus($query->status());
        $idBooking = new IdBooking($query->idBooking());
        $idAdmin = new IdAdmin($query->idAdmin());

        $response = $this->action($description, $remaining, $expire, $status, $idBooking, $idAdmin);
        return $response;
    }
}
