<?php

namespace App\Modules\Passenger\Domain;

use App\Modules\Group\Domain\IdGroup;

interface PassengerRepository
{
    public function updateDocuments(
        IdPassenger $idPassenger,
        PassengerImageDocument1 $passengerImageDocument1,
        PassengerImageDocument2 $passengerImageDocument2,
    );

    public function insert(Passenger $passenger);
    public function remove(IdPassenger $idPassenger);
    public function enable(IdPassenger $idPassenger);
    public function confirm(IdPassenger $idPassenger, PassengerConfirmMessage $message);
    public function deny(IdPassenger $idPassenger);
    public function index(IdPassenger $idPassenger);
    public function updateReportable(IdPassenger $idPassenger, PassengerReportable $reportable);
    public function reviewFromGroup(IdGroup $idGroup);
}
