<?php

namespace App\Modules\Passenger\Domain;

class PassengerReportable
{

    public const VALUE_NO = 1;
    public const VALUE_YES = 2;

    private int $value;

    public function __construct(int $value)
    {
        $values = [self::VALUE_NO, self::VALUE_YES];
        $this->value = in_array($value, $values) ? $value : $values[0];
    }

    public function getValue()
    {
        return $this->value;
    }
    public function toString()
    {
        switch ($this->value) {
        case self::VALUE_NO:
            return 'NO';
            break;
        case self::VALUE_YES:
            return 'SI';
            break;
        }
    }
}
