<?php

namespace App\Modules\Passenger\Application\ReviewFromGroup;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerReportable;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReviewFromGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private FromGroupPassengerReviewer $reviewer
    ) {
    }

    public function __invoke(ReviewFromGroupPassengerQuery $query): ReviewFromGroupPassengerResponses
    {
        return new ReviewFromGroupPassengerResponses(
            ...array_map(fn ($element) => new ReviewFromGroupPassengerResponse(
                $element->Id_GroupPassenger,
                $element->Id_Passenger,
                $element->Passenger_Name,
                $element->Passenger_LastName,
                $element->Passenger_Email,
                $element->Passenger_PhoneCode,
                $element->Passenger_Phone,
                $element->Passenger_Gender,
                $element->Passenger_DOB,
                $element->Passenger_NoDocument,
                $element->Passenger_Restriction,
                $element->Passenger_Extras,
                $element->Passenger_Reportable,
                $element->Passenger_Status,
                $element->User_Path,
                $element->Id_TypeDocument,
                $element->Id_UserCountry,
                $element->PassengerReviewAll_JSON,
                $element->PassengerReview_Reviewed,
                $element->PassengerReview_AnsweredAll,
                $element->PassengerReview_WholeScore,
                $element->ExternalReview
            ), $this->reviewer->__invoke(new IdGroup($query->idGroup())))
        );
    }
}
