<?php

namespace App\Modules\Passenger\Application\PayBookingTour;

use App\Modules\Passenger\Application\PayBookingTour\PayBookingTourPassengerCommand;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class PayBookingTourPassengerCommandHandler implements QueryHandler
{
    public function __construct(private PassengerBookingTourPayer $payer)
    {
    }

    public function __invoke(PayBookingTourPassengerCommand $query)
    {
        return $this->payer->__invoke(new IdPassenger($query->id()));
    }
}
