<?php

namespace App\Modules\Passenger\Application;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\PassengerReview\Domain\PassengerReviewRepository;

class PassengerPassengerFinder
{

    private PassengerReviewRepository $repository;

    public function __construct(PassengerReviewRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroup $idGroup, PassengerNoDocument $passengerNoDocument)
    {
        return $this->repository->passengerFindByGroup($idGroup, $passengerNoDocument);
    }
}
