<?php

namespace App\Modules\Passenger\Application\Create;

use App\Modules\Passenger\Application\Create\PassengerInserterResponse;
use App\Modules\Passenger\Domain\Passenger;
use App\Modules\Passenger\Domain\PassengerRepository;

final class PassengerInserter
{
    public function __construct(private PassengerRepository $repository)
    {
    }

    public function __invoke(Passenger $model): PassengerInserterResponse
    {
        return new PassengerInserterResponse($this->repository->insert($model));
    }
}
