<?php
namespace App\Modules\Modules\Domain\Structure;

use App\Modules\Shared\Domain\GenerateActionException;
use DateTime;

class ParamModuleDate extends ParamModule
{
    protected static $format = 'Y-m-d';

    public function __construct(
        private string $key,
        private $defaultValue
    ) {
        parent::__construct($key, 'date');
    }

    public function ensureIsValid($value)
    {
        $dt = DateTime::createFromFormat(self::$format, $value);
        if (!$dt || $dt->format(self::$format) !== $value) {
            (new GenerateActionException)("Invalid value for date: $value");
        }
        return $value;
    }

    public function defaultValue()
    {
        return $this->defaultValue;
    }
}
