<?php
namespace App\Modules\Modules\Domain\Structure;

use App\Modules\Shared\Domain\GenerateActionException;
use DateTime;

class ParamModuleBoolean extends ParamModule
{

    public function __construct(
        private string $key,
        private $defaultValue
    ) {
        parent::__construct($key, 'boolean');
    }

    public function ensureIsValid($value)
    {
        if (!is_bool(!!$value)) {
            (new GenerateActionException)("Invalid value for boolean: $value");
        }
        return $value;
    }

    public function defaultValue()
    {
        return $this->defaultValue;
    }
}
